using System;
using System.Data;
using System.Data.SqlClient;

using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stanislav Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>9/28/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Encapsulates DB data retrieval logic for the inappropriate transfusion request report.</summary>

	#endregion

	public class InappropriateTransfusionRequestReport
	{
		///<Developers>
		///	<Developer>Stas</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/25/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2121"> 
		///		<ExpectedInput>Appropriate date range (start date is before the end date) and valid division code.</ExpectedInput>
		///		<ExpectedOutput>
		///			Non-null result - DataSet, appropriate DataTables exist within the DataSet and no exception is thrown. 
		///			It is not feasible to predict how many records will the report return without fully replicating it in 
		///			unit tests. It is not also practically possible to set up a unit test that will create set of data 
		///			providing deterministic result.
		///		</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5843"> 
		///		<ExpectedInput>Bad date range (start date is after the end date) and valid division code.</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet (all tables are empty).</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2122"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Retrieves inappropriate transfusion request report data. Does not validate input datetime range, 
		/// if the range is invalid (start date is after the end date) it will return empty <see cref="DataTable"/>.
		/// </summary>
		/// <param name="reportStartDate">Report start date.</param>
		/// <param name="reportEndDate">Report end date.</param>
		/// <returns><see cref="DataTable"/> containing data for the report.</returns>
		public static DataSet GetReportData( DateTime reportStartDate, DateTime reportEndDate )
		{
			SqlParameter[] _prms = 
			{
				new SqlParameter( VbecsStoredProcs.GetInappropriateTransfusionRequests.startdate, SqlDbType.DateTime ),
				new SqlParameter( VbecsStoredProcs.GetInappropriateTransfusionRequests.enddate, SqlDbType.DateTime ),
				new SqlParameter( VbecsStoredProcs.GetInappropriateTransfusionRequests.divisioncode, SqlDbType.Char )		
			};

			_prms[0].Value = reportStartDate;
			_prms[1].Value = reportEndDate;
			_prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			DataSet _ds = StoredProcedure.GetData( VbecsStoredProcs.GetInappropriateTransfusionRequests.StoredProcName, _prms );

			_ds.DataSetName = DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.ReportDataSetName;
			_ds.Tables[0].TableName = DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.InappropriateSurgicalRequestsTableName;
			_ds.Tables[1].TableName = DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.InappropriateNonSurgicalRequestsTableName;
			_ds.Tables[2].TableName = DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.DivisionMsbosRecommendationsTableName;
			_ds.Tables[3].TableName = DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.DivisionTestingThresholdsTableName;

			return _ds;
		}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/28/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6760"> 
		///		<ExpectedInput>Valid date range.</ExpectedInput>
		///		<ExpectedOutput>No exception is thrown, non-negative integer.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6762"> 
		///		<ExpectedInput>Invalid date range (start date is after the end date).</ExpectedInput>
		///		<ExpectedOutput>0.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6761"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retrieves record count for the inappropriate transfusion requests report. 
		/// </summary>
		/// <param name="reportStartDate">Report start date.</param>
		/// <param name="reportEndDate">Report end date.</param>
		/// <returns>Record count for inappropriate transfusion requests report.</returns>
		public static int GetRecordCountEstimate( DateTime reportStartDate, DateTime reportEndDate )
		{
			SqlParameter[] _prms = 
			{
				new SqlParameter( VbecsStoredProcs.GetInappropriateTransfusionRequestReportCount.startdate, SqlDbType.DateTime ),
				new SqlParameter( VbecsStoredProcs.GetInappropriateTransfusionRequestReportCount.enddate, SqlDbType.DateTime ),
				new SqlParameter( VbecsStoredProcs.GetInappropriateTransfusionRequestReportCount.divisioncode, SqlDbType.Char )
			};

			_prms[0].Value = reportStartDate;
			_prms[1].Value = reportEndDate;
			_prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return new StoredProcedure().GetIntReturnValue( VbecsStoredProcs.GetInappropriateTransfusionRequestReportCount.StoredProcName, _prms );
		}
	}
}
